
function logoutSweetAlert(element) {
  Swal.fire({
    title: 'Ingin keluar dari aplikasi?',
    showDenyButton: true,
    showCancelButton: false,
    icon: 'warning',
    confirmButtonText: 'Konfirm..',
    denyButtonText: `Batal`,
  }).then((result) => {
    /* Read more about isConfirmed, isDenied below */
    if (result.isConfirmed) {
      Swal.fire({
          position: 'top-end',
          icon: 'success',
          title: 'Kerjaan kamu pada sistem telah disimpan, Terimakasih...',
          showConfirmButton: false,
          allowOutsideClick: false,
          // timer: 1500
        },
        setTimeout(() => {
          window.location = $(element).attr('data-location')
        }, "1500"))
    } else if (result.isDenied) {
      Swal.fire('Tidak jadi kerluar', '', 'info')
      Swal.fire({
        icon: 'info',
        title: 'Anda masih di Sistem aplikasi KKP',
        showConfirmButton: false,
        timer: 1500,
        allowOutsideClick: false
      })
    }
  })
}

function hapusData(){
  $(".formHapusData").submit(function(e) {
    e.preventDefault();
    Swal.fire({
      title: 'Hapus Data yang dipilih?',
      showDenyButton: true,
      showCancelButton: false,
      icon: 'warning',
      confirmButtonText: 'Konfirm..',
      denyButtonText: `Tidak`,
    }).then((result) => {
      /* Read more about isConfirmed, isDenied below */
      if (result.isConfirmed) {
        $.ajax({
          url: $(this).attr('action'),
          method: 'DELETE'
        }).done(function() {
          Swal.fire({
            position: 'top-end',
            icon: 'success',
            title: 'Data informasi berhasil dihapuskan!',
            showConfirmButton: false,
            allowOutsideClick: false,
          },
          setTimeout(() => {
            location.reload();
          }, "500"))
        }).fail(function(xhr, ajaxOptions, thrownError) {
          Swal.fire({
            icon: 'error',
            title: 'Oops...',
            text: 'Terjadi kesalahan, silahkan coba kembali atau hubungi pihak yang bersangkutan!'
          })
        });
      } else if (result.isDenied) {
        Swal.fire('Informasi data tidak dihapus', '', 'info')
        Swal.fire({
          icon: 'info',
          title: 'Data masih tersimpan pada sistem',
          showConfirmButton: false,
          timer: 1500,
          allowOutsideClick: false
        })
      }
    })
  });
}

$(function(){
  // Hapus Data
  $(".formHapusData").submit(function(e) {
    e.preventDefault();
    Swal.fire({
      title: 'Hapus Data yang dipilih?',
      showDenyButton: true,
      showCancelButton: false,
      icon: 'warning',
      confirmButtonText: 'Konfirm..',
      denyButtonText: `Tidak`,
    }).then((result) => {
      /* Read more about isConfirmed, isDenied below */
      if (result.isConfirmed) {
        $.ajax({
          url: $(this).attr('action'),
          method: 'DELETE'
        }).done(function() {
          Swal.fire({
            position: 'top-end',
            icon: 'success',
            title: 'Data informasi berhasil dihapuskan!',
            showConfirmButton: false,
            allowOutsideClick: false,
          },
          setTimeout(() => {
            location.reload();
          }, "500"))
        }).fail(function(xhr, ajaxOptions, thrownError) {
          Swal.fire({
            icon: 'error',
            title: 'Oops...',
            text: 'Terjadi kesalahan, silahkan coba kembali atau hubungi pihak yang bersangkutan!'
          })
        });
      } else if (result.isDenied) {
        Swal.fire('Informasi data tidak dihapus', '', 'info')
        Swal.fire({
          icon: 'info',
          title: 'Data masih tersimpan pada sistem',
          showConfirmButton: false,
          timer: 1500,
          allowOutsideClick: false
        })
      }
    })
  });
});