// adilanow760

function tampilKegiatan(){
  $.ajax({
    url: "/ski/skiGetRencana",
    method: 'get',
    dataType: "json",
    success: function(response) {
      if(response.error){        
        Swal.fire({
          position: 'top-end',
          icon: 'warning',
          title: 'Oops... Tidak ada akses',
          text: response.error,
        })
      }else{
        $(".rencana_kerja_table").html(response.data);
      }
    },
    error: function(xhr, ajaxOptions, thrownError) {
      alert(xhr.status + "\n" + xhr.responseText + "\n" + thrownError);
      Swal.fire({
        position: 'top-end',
        icon: 'error',
        title: 'Oops... ERROR SINTAKS',
        text: 'Terjadi kesalahan pemrograman saat mengambil data silahkan hubungi pihak yang terkait',
      })
    }
  });
}

function editRencanaKerja(data) {
  const id = data

  $.ajax({
    type: "get",
    url: "/get/rencana/"+data,
    dataType: "json",
    beforeSend: function() {
      $(".loading").addClass('overlay');
      $(".loading").html('<i class="fas fa-2x fa-sync fa-spin"></i>');
    },
    success: function(response) {
      if(response.sukses){
        $("#modal-editRencanaKerja #id_rencana_kerja").val(response.sukses['id_rencana_kerja'])
        $("#modal-editRencanaKerja #no").val(response.sukses['no'])
        $("#modal-editRencanaKerja #poin").val(response.sukses['poin'])
        $("#modal-editRencanaKerja #rencana").val(response.sukses['rencana'])
        $("#modal-editRencanaKerja #bulan").val(response.sukses['bulan'])
        $("#modal-editRencanaKerja #minggu").val(response.sukses['minggu'])

        $("#modal-editRencanaKerja #minggu").val(response.sukses['minggu'])
        var option = $("#modal-editRencanaKerja #minggu").find("option[value='" + response.sukses['minggu'] + "']");
        option.text("new text");
        

        $(".loading").removeClass('overlay');
        $(".loading").html('');
        $(".btnsimpan").removeAttr('disabled');
        $(".btnsimpan").html('Simpan');
      }else{
        Swal.fire({
          position: 'top-end',
          icon: 'error',
          title: 'Oops...',
          text: response.error,
        })
      }
      
    },
    error: function(xhr, ajaxOptions, thrownError) {    
      alert(xhr.status + "\n" + xhr.responseText + "\n" + thrownError);  
      Swal.fire({
        position: 'top-end',
        icon: 'error',
        title: 'Oops... ERROR SINTAKS',
        text: 'Terjadi kesalahan pemrograman saat mengambil data silahkan hubungi pihak yang terkait',
      })
    }
  })

  $('#periode').text('');
}

function updateRencanaKerja(id, bulan, minggu){
  let namaBulan;
  switch (bulan) {
    case 1:
      namaBulan = "Januari";
      break;
    case 2:
      namaBulan = "Februari";
      break;
    case 3:
      namaBulan = "Maret";
      break;
    case 4:
      namaBulan = "April";
      break;
    case 5:
      namaBulan = "Mei";
      break;
    case 6:
      namaBulan = "Juni";
      break;
    case 7:
      namaBulan = "Juli";
      break;
    case 8:
      namaBulan = "Agustus";
      break;
    case 9:
      namaBulan = "September";
      break;
    case 10:
      namaBulan = "Oktober";
      break;
    case 11:
      namaBulan = "November";
      break;
    case 12:
      namaBulan = "Desember";
      break;
    default:
      namaBulan = "Hari tidak valid";
      break;
  }

  Swal.fire({
    title: 'Perubahan Rencana Kerja Pada Bulan '+namaBulan+' Minggu ke-'+minggu+'?',
    showDenyButton: true,
    showCancelButton: false,
    icon: 'warning',
    confirmButtonText: 'Konfirm..',
    denyButtonText: `Tidak`,
  }).then((result) => {
    /* Read more about isConfirmed, isDenied below */
    if (result.isConfirmed) {
      $.ajax({
        url: "/ski/updateRencanaKerja/"+id+"/"+bulan+"/"+minggu,
        method: 'post'
      }).done(function() {
        Swal.fire({
          position: 'top-end',
          icon: 'success',
          title: 'Data informasi berhasil diperbaharui!',
          showConfirmButton: true,
          allowOutsideClick: false,
        },
        setTimeout(() => {
          tampilKegiatan();
        }, "100"))
      }).fail(function(xhr, ajaxOptions, thrownError) {
        Swal.fire({
          icon: 'error',
          title: 'Oops...',
          text: xhr.status + "\n" + xhr.responseText + "\n" + thrownError
          // text: 'Terjadi kesalahan, silahkan coba kembali atau hubungi pihak yang bersangkutan!'
        })
      });
    } else if (result.isDenied) {
      // Swal.fire('Informasi data tidak dihapus', '', 'info')
      // Swal.fire({
      //   icon: 'info',
      //   title: 'Data masih tersimpan pada sistem',
      //   showConfirmButton: false,
      //   timer: 1500,
      //   allowOutsideClick: false
      // })
    }
  })
}

$(function (){
  tampilKegiatan();
  $(".plus").click(function(){
    
    $(".multiple-column").append( 
      '<div class="form-group row">' +
      '<div class="col-md-6">' +
        '<label>Bulan</label>' +
        '<select class="form-control" name="bulan[]" id="bulan" style="width: 100%;">' +
          '<option value=""> --Pilih Bulan-- </option>' +
          '<option value="Januari"> Januari </option>' +
          '<option value="Februari"> Februari </option>' +
          '<option value="Maret"> Maret </option>' +
          '<option value="April"> April </option>' +
          '<option value="Mei"> Mei </option>' +
          '<option value="Juni"> Juni </option>' +
          '<option value="Juli"> Juli </option>' +
          '<option value="Agustus"> Agustus </option>' +
          '<option value="September"> September </option>' +
          '<option value="Oktober"> Oktober </option>' +
          '<option value="November"> November </option>' +
          '<option value="Desember"> Desember </option>' +
        '</select>' +
      '</div>' +
      '<div class="col-md-6">' +
        '<label for="minggu_ke">Minggu Ke</label><span class="min" onclick="$(this).parent().parent().remove();">-</span>' +
        '<input type="number" min="1" max="4" name="minggu_ke[]" class="form-control" id="minggu_ke" placeholder="1-4" value="">' +
      '</div>' +
    '</div>'
    );
  });

  $(".formKegiatan").submit(function(e) {
    e.preventDefault();

    // tambahkan baris ini untuk menjalankan validasi form
    if (!$(this).valid()) return;
    var formData = new FormData($(this)[0]);
    $.ajax({
      type: "post",
      url: $(this).attr('action'),
      data: formData,
      processData: false,
      contentType: false,
      dataType: "json",
      beforeSend: function() {
        $(".btnsimpan").attr('disabled', 'disabled');
        $(".btnsimpan").html('<i class="fa fa-spin fa-spinner"></i>');
      },
      complete: function() {
        $(".btnsimpan").removeAttr('disabled');
        $(".btnsimpan").html('Simpan');
      },
      success: function(response) {
        
        if(response.error){
          Swal.fire({
            position: 'top-end',
            icon: 'error',
            title: 'Oops... GAGAL MENYIMPAN',
            text: response.error,
          })
        }else{
          Swal.fire({
            position: 'top-end',
            icon: 'success',
            title: 'Data berhasil disimpan pada database',
            showConfirmButton: false,
            allowOutsideClick: false,
            // timer: 1500
          },
          setTimeout(() => {
            location.reload();
          }, "500"))
        }
      },
      error: function(xhr, ajaxOptions, thrownError) {
        alert(xhr.status + "\n" + xhr.responseText + "\n" + thrownError);
        Swal.fire({
          position: 'top-end',
          icon: 'error',
          title: 'Oops... ERROR SINTAKS',
          text: 'Terjadi kesalahan pemrograman saat mengambil data silahkan hubungi pihak yang terkait',
        })
      }
    })
  });
})