function tambahPeriodePenilaian() {
  
  $.ajax({
    type: "get",
    url: "/get/periodePenilaian/",
    dataType: "json",
    beforeSend: function() {
      $(".loading").addClass('overlay');
      $(".loading").html('<i class="fas fa-2x fa-sync fa-spin"></i>');
    },
    success: function(response) {
      if(response.sukses){
        if(response.nilai1){
          
          var data1 = '';      
          for(let i=0; i<response.nilai1.length; i++){
            data1 = data1 + '<option value="'+response.nilai1[i]['id_periode']+'"> '+response.nilai1[i]['periode']+' : '+response.nilai1[i]['status']+' </option>'
          }

          $("#modal-tambahPeriodePenilaian #select2PeriodePenilaian").prepend(
            '<option value=""> --Pilih Status-- </option>'+
            data1
          );
        }
        if(response.nilai2){
          
          var data2 = '';

          for(let i=0; i<response.nilai2.length; i++){
            data2 = data2 + '<option disabled="disabled" value="'+response.nilai2[0]['id_periode']+'"> '+response.nilai2[0]['periode']+' : '+response.nilai2[0]['status']+' </option>'
          }

          $("#modal-tambahPeriodePenilaian #select2PeriodePenilaian").append(
            data2
          )
        }

        $("#modal-tambahPeriodePenilaian #select2PeriodePenilaian").select2();

        $(".loading").removeClass('overlay');
        $(".loading").html('');
        $(".btnsimpan").removeAttr('disabled');
        $(".btnsimpan").html('Simpan');
      }else{
        Swal.fire({
          position: 'top-end',
          icon: 'error',
          title: 'Oops...',
          text: response.error,
        })
      }
      
    },
    error: function(xhr, ajaxOptions, thrownError) {      
      Swal.fire({
        position: 'top-end',
        icon: 'error',
        title: 'Oops... ERROR SINTAKS',
        text: 'Terjadi kesalahan pemrograman saat mengambil data silahkan hubungi pihak yang terkait',
      })
    }
  })

}
function exportDataSKI(event){
  window.location.replace(event);
  let timerInterval
  Swal.fire({
    position: 'top-end',
    title: 'Menyimpan data!',
    html: 'Proses selama <b></b> milliseconds.',
    timerProgressBar: true,
    allowOutsideClick: false,
    timer: 2000,
    didOpen: () => {
      Swal.showLoading()
      const b = Swal.getHtmlContainer().querySelector('b')
      timerInterval = setInterval(() => {
        b.textContent = Swal.getTimerLeft()
      }, 100)
    },
    willClose: () => {
      clearInterval(timerInterval)
    }
  }).then((result) => {
    /* Read more about handling dismissals below */
    if (result.dismiss === Swal.DismissReason.timer) {
      Swal.fire({
        position: 'top-end',
        icon: 'success',
        title: 'Response data berhasil, download akan terjadi secara otomatis, harap tunggu',
        showConfirmButton: true,
      })
    }
  })

}
$(function() {

  $(".formPeriodePenilaian").submit(function(e) {
    e.preventDefault();

    // tambahkan baris ini untuk menjalankan validasi form
    if (!$(this).valid()) return;

    $.ajax({
      type: "post",
      url: $(this).attr('action'),
      data: $(this).serialize(),
      dataType: "json",
      beforeSend: function() {
        $(".btnsimpan").attr('disabled', 'disabled');
        $(".btnsimpan").html('<i class="fa fa-spin fa-spinner"></i>');
      },
      complete: function() {
        $(".btnsimpan").removeAttr('disabled');
        $(".btnsimpan").html('Simpan');
      },
      success: function(response) {
        if(response.error){
          Swal.fire({
            position: 'top-end',
            icon: 'error',
            title: 'Oops... GAGAL MENYIMPAN',
            text: response.error,
          })
        }else{
          Swal.fire({
            position: 'top-end',
            icon: 'success',
            title: 'Data berhasil disimpan pada database',
            showConfirmButton: false,
            allowOutsideClick: false,
            // timer: 1500
          },
          setTimeout(() => {
            location.reload();
          }, "500"))
        }
      },
      error: function(xhr, ajaxOptions, thrownError) {
        Swal.fire({
          position: 'top-end',
          icon: 'error',
          title: 'Oops... ERROR SINTAKS',
          text: 'Terjadi kesalahan pemrograman saat mengambil data silahkan hubungi pihak yang terkait',
        })
      }
    })
  });
});