
function editPeriode(data) {
  const id = data
  $.ajax({
    type: "get",
    url: "/get/periode/"+data,
    dataType: "json",
    beforeSend: function() {
      $(".loading").addClass('overlay');
      $(".loading").html('<i class="fas fa-2x fa-sync fa-spin"></i>');
    },
    success: function(response) {
      if(response.sukses){
        $("#modal-editPeriode #id_periode").val(response.sukses['id_periode'])
        $("#modal-editPeriode #status").val(response.sukses['status'])
        $("#modal-editPeriode #periode").val(response.sukses['periode'])
        $("#modal-editPeriode .periode").text(response.sukses['periode'])
        $("#modal-editPeriode #tgl_periode").val(response.sukses['tgl_periode'])

        $(".loading").removeClass('overlay');
        $(".loading").html('');
        $(".btnsimpan").removeAttr('disabled');
        $(".btnsimpan").html('Simpan');
      }else{
        Swal.fire({
          position: 'top-end',
          icon: 'error',
          title: 'Oops...',
          text: response.error,
        })
      }
      
    },
    error: function(xhr, ajaxOptions, thrownError) {      
      Swal.fire({
        position: 'top-end',
        icon: 'error',
        title: 'Oops... ERROR SINTAKS',
        text: 'Terjadi kesalahan pemrograman saat mengambil data silahkan hubungi pihak yang terkait',
      })
    }
  })

  $('#periode').text('');
}
$(function() {

  $(".formPeriode").submit(function(e) {
    e.preventDefault();

    // tambahkan baris ini untuk menjalankan validasi form
    if (!$(this).valid()) return;

    $.ajax({
      type: "post",
      url: $(this).attr('action'),
      data: $(this).serialize(),
      dataType: "json",
      beforeSend: function() {
        $(".btnsimpan").attr('disabled', 'disabled');
        $(".btnsimpan").html('<i class="fa fa-spin fa-spinner"></i>');
      },
      complete: function() {
        $(".btnsimpan").removeAttr('disabled');
        $(".btnsimpan").html('Simpan');
      },
      success: function(response) {
        if(response.error){
          Swal.fire({
            position: 'top-end',
            icon: 'error',
            title: 'Oops... GAGAL MENYIMPAN',
            text: response.error,
          })
        }else{
          Swal.fire({
            position: 'top-end',
            icon: 'success',
            title: 'Data berhasil disimpan pada database',
            showConfirmButton: false,
            allowOutsideClick: false,
            // timer: 1500
          },
          setTimeout(() => {
            location.reload();
          }, "500"))
        }
      },
      error: function(xhr, ajaxOptions, thrownError) {
        Swal.fire({
          position: 'top-end',
          icon: 'error',
          title: 'Oops... ERROR SINTAKS',
          text: 'Terjadi kesalahan pemrograman saat mengambil data silahkan hubungi pihak yang terkait',
        })
      }
    })
  });
});