function editKegiatan(data) {
  const id = data

  $.ajax({
    type: "get",
    url: "/get/kegiatan/"+data,
    dataType: "json",
    beforeSend: function() {
      $(".loading").addClass('overlay');
      $(".loading").html('<i class="fas fa-2x fa-sync fa-spin"></i>');
    },
    success: function(response) {
      if(response.sukses){
        $("#modal-editKegiatan #id_kegiatan").val(response.sukses['id_kegiatan'])
        $("#modal-editKegiatan #nama_kegiatan").val(response.sukses['nama_kegiatan'])
        $("#modal-editKegiatan #ket").summernote("code", response.sukses['ket']);
        
        $("#modal-editKegiatan #ket").summernote({
          tabsize: 2,
          height: 300,
          lineHeight: 1.5
        })
        
        $("#modal-editKegiatan #foto_kegiatan").next('.custom-file-label').addClass('selected').html(response.sukses['foto_kegiatan']);



        $(".loading").removeClass('overlay');
        $(".loading").html('');
        $(".btnsimpan").removeAttr('disabled');
        $(".btnsimpan").html('Simpan');
      }else{
        Swal.fire({
          position: 'top-end',
          icon: 'error',
          title: 'Oops...',
          text: response.error,
        })
      }
      
    },
    error: function(xhr, ajaxOptions, thrownError) {    
      alert(xhr.status + "\n" + xhr.responseText + "\n" + thrownError);  
      Swal.fire({
        position: 'top-end',
        icon: 'error',
        title: 'Oops... ERROR SINTAKS',
        text: 'Terjadi kesalahan pemrograman saat mengambil data silahkan hubungi pihak yang terkait',
      })
    }
  })

  $('#periode').text('');
}

$(function (){

  $(".formKegiatan").submit(function(e) {
    e.preventDefault();

    // tambahkan baris ini untuk menjalankan validasi form
    if (!$(this).valid()) return;
    var formData = new FormData($(this)[0]);
    $.ajax({
      type: "post",
      url: $(this).attr('action'),
      data: formData,
      processData: false,
      contentType: false,
      dataType: "json",
      beforeSend: function() {
        $(".btnsimpan").attr('disabled', 'disabled');
        $(".btnsimpan").html('<i class="fa fa-spin fa-spinner"></i>');
      },
      complete: function() {
        $(".btnsimpan").removeAttr('disabled');
        $(".btnsimpan").html('Simpan');
      },
      success: function(response) {
        
        if(response.error){
          Swal.fire({
            position: 'top-end',
            icon: 'error',
            title: 'Oops... GAGAL MENYIMPAN',
            text: response.error,
          })
        }else{
          Swal.fire({
            position: 'top-end',
            icon: 'success',
            title: 'Data berhasil disimpan pada database',
            showConfirmButton: false,
            allowOutsideClick: false,
            // timer: 1500
          },
          setTimeout(() => {
            location.reload();
          }, "500"))
        }
      },
      error: function(xhr, ajaxOptions, thrownError) {
        alert(xhr.status + "\n" + xhr.responseText + "\n" + thrownError);
        Swal.fire({
          position: 'top-end',
          icon: 'error',
          title: 'Oops... ERROR SINTAKS',
          text: 'Terjadi kesalahan pemrograman saat mengambil data silahkan hubungi pihak yang terkait',
        })
      }
    })
  });
})