
$(document).ready(function() {

  $('#tambahPegawai #nama').change(function() {
    var nama = $('#nama').val()
    $('#nama_pegawai').val(nama)
  });


  // add the rule here
  jQuery.validator.addMethod("noSpace", function(value, element) {
    return value.indexOf(" ") < 0 && value != "";
  }, "No space please and don't leave it empty");

  $.validator.addMethod("valueNotEquals", function(value, element, arg) {
    return arg !== value;
  }, "Value must not equal arg.");

  $.validator.addMethod("maxFileSize", function(value, element, param) {
    // Cek ukuran file yang diunggah
    return this.optional(element) || (element.files[0].size <= param);
  }, "File terlalu besar");

  $.validator.addMethod("pdf", function(value, element) {
      // Cek apakah file yang diunggah adalah file PDF
      return this.optional(element) || (value.match(/\.pdf$/i));
  }, "File harus berupa dokumen PDF");

  $.validator.addMethod("image", function(value, element) {
    // Cek apakah file yang diunggah adalah file gambar dengan ekstensi PNG, JPG, JPEG, GIF, BMP, atau SVG
    return this.optional(element) || (value.match(/\.(png|jpg|jpeg|gif|bmp|svg)$/i));
}, "File harus berupa gambar dengan ekstensi PNG, JPG, JPEG, GIF, BMP, atau SVG");



  $(function() {
    // $.validator.setDefaults({
    //     submitHandler: function() {
    //         alert("Memproses data!");
    //     }
    // });
    $('#tambahPengguna').validate({
      rules: {
        role_access: {
          required: true
        },
        nama: {
          required: true,
          maxlength: 50,
        },
        username: {
          required: true,
          noSpace: true,
          minlength: 8,
          maxlength: 25
        },
        password: {
          required: true,
          minlength: 8,
          maxlength: 255
        },
        password2: {
          required: true,
          equalTo: "#password"
        }
      },
      messages: {
        role_access: {
          required: "Pilih akses pengguna!"
        },
        nama: {
          required: "Masukkan kolom nama!",
          maxlength: "Panjang nama yang dimasukkan maksimal 50 karakter"
        },
        username: {
          required: "Masukkan kolom username",
          noSpace: "Masukkan kolom username tanpa spasi!",
          minlength: "Panjang nama yang dimasukkan minimal 8 karakter",
          maxlength: "Panjang nama yang dimasukkan maksimal 25 karakter"
        },
        password: {
          required: "Masukkan kolom password!",
          minlength: "Panjang password yang dimasukkan minimal 8 karakter",
          maxlength: "Password yang dimasukkan terlalu panjang"
        },
        password2: {
          required: "Masukkan kolom konfirmasi password!",
          equalTo: "Password yang dimasukkan tidak sama!"
        }
      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });
  });
  $(function() {
    // $.validator.setDefaults({
    //     submitHandler: function() {
    //         alert("Memproses data!");
    //     }
    // });
    $('#tambahUnitKerja').validate({
      rules: {
        unit_kerja: {
          required: true,
          maxlength: 128
        },
        lokasi: {
          required: true,
          maxlength: 25,
        }
      },
      messages: {
        unit_kerja: {
          required: "Masukkan kolom unit kerja!",
          maxlength: "Panjang nama yang dimasukkan maksimal 128 karakter"
        },
        lokasi: {
          required: "Masukkan kolom nama!",
          maxlength: "Panjang nama yang dimasukkan maksimal 25 karakter"
        }
      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });
  });

  $(function() {
    // $.validator.setDefaults({
    //     submitHandler: function() {
    //         alert("Memproses data!");
    //     }
    // });
    $('#tambahPegawai').validate({
      rules: {
        role_access: {
          required: true
        },
        nama: {
          required: true,
          maxlength: 50
        },
        username: {
          required: true,
          noSpace: true,
          minlength: 8,
          maxlength: 25
        },
        password: {
          required: true,
          minlength: 8,
          maxlength: 255
        },
        password2: {
          required: true,
          equalTo: "#password"
        },
        unit_kerja: {
          required: true
        },
        jabatan: {
          required: true,
          maxlength: 128
        },
        nip: {
          required: true,
          digits: true,
          minlength: 18,
          maxlength: 18
        },
        golongan: {
          required: true,
          maxlength: 10
        },
        tahun: {
          required: true,
          digits: true,
          min: 0
        },
        bulan: {
          required: true,
          digits: true,
          min: 0,
          max: 12
        },
        hari:{
          required: true,
          digits: true,
          min: 0,
          max: 31
        }
      },
      messages: {
        role_access: {
          required: "Pilih akses pengguna!"
        },
        nama: {
          required: "Masukkan kolom nama!",
          maxlength: "Panjang nama yang dimasukkan maksimal 50 karakter"
        },
        username: {
          required: "Masukkan kolom username",
          noSpace: "Masukkan kolom username tanpa spasi!",
          minlength: "Panjang nama yang dimasukkan minimal 8 karakter",
          maxlength: "Panjang nama yang dimasukkan maksimal 25 karakter"
        },
        password: {
          required: "Masukkan kolom password!",
          minlength: "Panjang password yang dimasukkan minimal 8 karakter",
          maxlength: "Password yang dimasukkan terlalu panjang"
        },
        password2: {
          required: "Masukkan kolom konfirmasi password!",
          equalTo: "Password yang dimasukkan tidak sama!"
        },
        unit_kerja: {
          required: "Pilih unit kerja!"
        },
        jabatan: {
          required: "Masukkan kolom jabatan!",
          maxlength: "Panjang jabatan yang dimasukkan maksimal 128 karakter"
        },
        nip: {
          required: "Masukkan kolom NIP!",
          digits: "Hanya angka yang boleh diisi!",
          minlength: "Panjang NIP yang dimasukkan 18 karakter",
          maxlength: "Panjang NIP yang dimasukkan 18 karakter"
        },
        golongan: {
          required: "Masukkan kolom golongan!",
          maxlength: "Panjang golongan yang dimasukkan 10 karakter"
        },
        tahun: {
          required: "Masukkan kolom tahun! <br/>",
          digits: "Hanya angka yang boleh diisi! <br/>",
          min: "Jumlah lamanya tahun sama dengan/lebih besar dari 0 <br/>"
        },
        bulan: {
          required: "Masukkan kolom bulan! <br/>",
          digits: "Hanya angka yang boleh diisi! <br/>",
          min: "Jumlah lamanya bulan minimal sama dengan/lebih besar dari 0 <br/>",
          max: "Jumlah lamanya bulan maximal 12 <br/>"
        },
        hari: {
          required: "Masukkan kolom hari! <br/>",
          digits: "Hanya angka yang boleh diisi! <br/>",
          min: "Jumlah lamanya bulan minimal sama dengan/lebih besar dari 0 <br/>",
          max: "Jumlah lamanya bulan maximal 31 <br/>"
        },
      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      },

    });
  });
  
  $(function() {
    $('#tambahPeriode').validate({
      rules: {
        periode: {
          required: true,
          maxlength: 64
        },
        tgl_periode: {
          required: true,
        }
      },
      messages: {
        periode: {
          required: "Masukkan kolom periode!",
          maxlength: "Panjang karakter yang dimasukkan maksimal 64 karakter"
        },
        tgl_periode: {
          required: "Masukkan kolom tanggal periode!",
        }
      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });
  });
  $(function() {
    $('#tambahPeriodePenilaian').validate({
      rules: {
        periode: {
          required: true,
        },
        tgl_periode: {
          required: true,
        }
      },
      messages: {
        periode: {
          required: "Masukkan kolom periode!",
        }
      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });
  });
  $(function() {
    $('#tambahDokumen').validate({
      rules: {
        nama_dokumen: {
          required: true,
          maxlength: 250,
        },
        file_dokumen: {
          required: true,
          extension: "pdf",
          maxFileSize: 5242880 // Batas maksimal ukuran file dalam bytes (contoh: 5 megabytes)
        }
      },
      messages: {
        nama_dokumen: {
          required: "Masukkan kolom periode!",
          maxlength: "Panjang karakter yang dimasukkan maksimal {0} karakter",
        },
        file_dokumen: {
          required: "File harus diunggah",
          extension: "File harus berupa dokumen PDF",
          maxFileSize: "Ukuran file maksimal {0} bytes"
        }
      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });
  });
  $(function() {
    $('#editDokumen').validate({
      rules: {
        nama_dokumen: {
          required: true,
          maxlength: 250,
        },
        file_dokumen: {
          extension: "pdf",
          maxFileSize: 5242880 // Batas maksimal ukuran file dalam bytes (contoh: 5 megabytes)
        }
      },
      messages: {
        nama_dokumen: {
          required: "Masukkan kolom periode!",
          maxlength: "Panjang karakter yang dimasukkan maksimal {0} karakter",
        },
        file_dokumen: {
          required: "File harus diunggah",
          extension: "File harus berupa dokumen PDF",
          maxFileSize: "Ukuran file maksimal {0} bytes"
        }
      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });
  });
  $(function() {
    $('#tambahKegiatan').validate({
      rules: {
        nama_kegiatan: {
          required: true,
          maxlength: 64,
        },
        ket:{
          required: true
        },
        foto_kegiatan: {
          required: true,
          image: true,
          maxFileSize: 5242880 // Batas maksimal ukuran file dalam bytes (contoh: 5 megabytes)
        }
      },
      messages: {
        nama_kegiatan: {
          required: "Masukkan kolom periode!",
          maxlength: "Panjang karakter yang dimasukkan maksimal {0} karakter",
        },
        ket:{
          required: "Masukkan keterangan sebagai informasi"
        },
        foto_kegiatan: {
          required: "Gambar harus diunggah",
          image: "Gambar harus berupa gambar dengan ekstensi PNG, JPG, JPEG, GIF, BMP, atau SVG",
          maxFileSize: "Ukuran file maksimal {0} bytes"
        }
      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });
  });
  $(function() {
    $('#editKegiatan').validate({
      rules: {
        nama_kegiatan: {
          required: true,
          maxlength: 64,
        },
        ket:{
          required: true
        },
        foto_kegiatan: {
          image: true,
          maxFileSize: 5242880 // Batas maksimal ukuran file dalam bytes (contoh: 5 megabytes)
        }
      },
      messages: {
        nama_kegiatan: {
          required: "Masukkan kolom periode!",
          maxlength: "Panjang karakter yang dimasukkan maksimal {0} karakter",
        },
        ket:{
          required: "Masukkan keterangan sebagai informasi"
        },
        foto_kegiatan: {
          required: "Gambar harus diunggah",
          image: "Gambar harus berupa gambar dengan ekstensi PNG, JPG, JPEG, GIF, BMP, atau SVG",
          maxFileSize: "Ukuran file maksimal {0} bytes"
        }
      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });
  });
});